/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.VWScenarioOperationDefinition;
import filenet.sim.api.VWScenarioQueueDefinition;
import filenet.sim.api.VWScenarioXMLHandler;
import filenet.vw.api.VWException;
import filenet.vw.api.VWOperationDefinition;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWSystemConfiguration;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class VWScenarioConfiguration
implements Serializable {
    private static final String CONDUCTOR_QUEUE = "Conductor";
    private String m_serviceName = null;
    private int m_region = -1;
    private Map<String, VWScenarioQueueDefinition> m_queues = Collections.synchronizedMap(new HashMap());

    protected VWScenarioConfiguration(String serviceName, int region) throws VWException {
        this.m_serviceName = serviceName;
        this.m_region = region;
    }

    protected VWScenarioConfiguration(VWSession session, VWSystemConfiguration sysConfig) throws VWException {
        this(session.getServerName(), session.getIsolatedRegion());
        if (sysConfig != null) {
            VWScenarioQueueDefinition qDef;
            VWQueueDefinition[] queueDefs = sysConfig.getQueueDefinitions();
            if (queueDefs != null) {
                for (int i = 0; i < queueDefs.length; ++i) {
                    int nIndex;
                    String queueName = queueDefs[i].getName();
                    if (queueDefs[i].getQueueType() == 2 && (nIndex = queueName.indexOf("(")) > 0) {
                        queueName = queueName.substring(0, nIndex);
                    }
                    VWScenarioQueueDefinition qDef2 = this.createQueue(queueName, i);
                    VWOperationDefinition[] operationDefs = queueDefs[i].getOperations();
                    if (operationDefs == null) continue;
                    for (int j = 0; j < operationDefs.length; ++j) {
                        if (operationDefs[j].getName() == null) continue;
                        qDef2.createOperation(operationDefs[j].getName(), j);
                    }
                }
            }
            if (this.m_queues != null && !this.m_queues.containsKey(CONDUCTOR_QUEUE) && (qDef = this.createQueue(CONDUCTOR_QUEUE, this.m_queues.size())) != null) {
                qDef.createOperation("Review", 0);
            }
        } else {
            String[] queueNames = session.fetchQueueNames(3);
            HashSet<String> queueTable = new HashSet<String>();
            for (int i = 0; i < queueNames.length; ++i) {
                VWQueue queue = session.getQueue(queueNames[i]);
                String queueName = queueNames[i];
                if (queue.getQueueType() == 2) {
                    int index = queueName.indexOf("(");
                    if (index > 0) {
                        queueName = queueName.substring(0, index);
                    }
                    if (queueTable.contains(queueName)) continue;
                    queueTable.add(queueName);
                }
                VWScenarioQueueDefinition qDef = this.createQueue(queueName, session.convertClassNameToId(queueName, true));
                String[] opNames = queue.fetchOperationNames();
                if (opNames == null) continue;
                for (int j = 0; j < opNames.length; ++j) {
                    if (opNames[j] == null) continue;
                    qDef.createOperation(opNames[j], queue.convertOperationNameToId(opNames[j]));
                }
            }
        }
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public int getIsolatedRegion() {
        return this.m_region;
    }

    public VWScenarioQueueDefinition[] getQueues() {
        if (this.m_queues.size() == 0) {
            return null;
        }
        return this.m_queues.values().toArray(new VWScenarioQueueDefinition[0]);
    }

    public VWScenarioQueueDefinition getQueue(String queueName) throws VWException {
        if (queueName == null) {
            throw new VWException("sim.api.VWScenarioConfiguration.NullQueueNameParameter", "The queueName parameter can not be null.");
        }
        if (!this.m_queues.containsKey(queueName)) {
            throw new VWException("sim.api.VWScenarioConfiguration.QueueDefinitionNotFound", "Queue {0} is not valid for this scenario.", queueName);
        }
        return this.m_queues.get(queueName);
    }

    protected VWScenarioQueueDefinition createQueue(String queueName, int queueId) throws VWException {
        if (this.m_queues.containsKey(queueName)) {
            throw new VWException("sim.api.VWScenarioConfiguration.QueueAlreadyExists", "A queue with the name {0} already exists.", queueName);
        }
        VWScenarioQueueDefinition queue = new VWScenarioQueueDefinition(queueName, queueId);
        this.m_queues.put(queueName, queue);
        return queue;
    }

    public void toXML(StringBuffer buffer) throws VWException {
        this.toXML(buffer, "");
    }

    protected void toXML(StringBuffer buffer, String baseIndent) throws VWException {
        String LEVEL_1_INDENT = baseIndent + "\t";
        String LEVEL_2_INDENT = LEVEL_1_INDENT + "\t";
        String LEVEL_3_INDENT = LEVEL_2_INDENT + "\t";
        String LEVEL_4_INDENT = LEVEL_3_INDENT + "\t";
        String LEVEL_5_INDENT = LEVEL_4_INDENT + "\t";
        buffer.append(baseIndent + "<ConfigurationDefinitions>\n");
        buffer.append(LEVEL_1_INDENT + "<Configuration ");
        buffer.append("SystemName=\"" + VWScenarioXMLHandler.toXMLString(this.getServiceName()) + "\" ");
        buffer.append("RegionId=\"" + VWScenarioXMLHandler.toXMLString("" + this.getIsolatedRegion()) + "\" ");
        buffer.append(">\n");
        buffer.append(LEVEL_2_INDENT + "<Queues>\n");
        VWScenarioQueueDefinition[] queues = this.getQueues();
        if (queues != null) {
            for (int i = 0; i < queues.length; ++i) {
                VWScenarioOperationDefinition[] ops;
                buffer.append(LEVEL_3_INDENT + "<Queue ");
                buffer.append("Name=\"" + VWScenarioXMLHandler.toXMLString(queues[i].getName()) + "\" ");
                buffer.append("Id=\"" + queues[i].getId() + "\">\n");
                buffer.append(LEVEL_4_INDENT + "<Operations>\n");
                if (!queues[i].hasOperation("F_Default")) {
                    buffer.append(LEVEL_5_INDENT + "<Operation Name=\"F_Default\" Id=\"-1\"/>\n");
                }
                if ((ops = queues[i].getOperations()) != null) {
                    for (int j = 0; j < ops.length; ++j) {
                        buffer.append(LEVEL_5_INDENT + "<Operation ");
                        buffer.append("Name=\"" + VWScenarioXMLHandler.toXMLString(ops[j].getName()) + "\" ");
                        buffer.append("Id=\"" + ops[j].getId() + "\"/>\n");
                    }
                }
                buffer.append(LEVEL_4_INDENT + "</Operations>\n");
                buffer.append(LEVEL_3_INDENT + "</Queue>\n");
            }
        }
        buffer.append(LEVEL_2_INDENT + "</Queues>\n");
        buffer.append(LEVEL_1_INDENT + "</Configuration>\n");
        buffer.append(baseIndent + "</ConfigurationDefinitions>\n");
    }
}

